/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.NoSuchObjectIdException;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.UIObjectsFilter;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.ui.AbstractUIAction;
import com.ibm.hwmca.fw.ui.DisplayChildrenUIAction;
import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsOffsets;
import com.ibm.hwmca.fw.ui.UIPropertyChangeEvent;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIObjectsWriter
extends UIObjectProperties
implements PropertyChangeListener,
UILog {
    private ManagedObjectManager mom;
    private ShortObjectIdManager shortIdManager;
    private UIObjectsOffsets recordOffsets;
    private HashMap statusShortIds;
    private HashMap attentionTaskShortIds;
    private HashMap listeners;
    private Object listenersLock = new Object();
    private Object attnLock = new Object();
    private Object actionsLock = new Object();
    private Set allSupportedStatus;
    private Worker worker;
    private File objectsFile;
    private RandomAccessFile objectsWriter;
    private File unacceptableFile;
    private File rootFile;
    private String groupFilePrefix;
    private String taskGroupFilePrefix;
    private String moGroupFilePrefix;
    private static UIObjectsWriter instance;
    private HashMap uiActions;
    private static String[] MANAGED_OBJECT_PROPERTIES;
    private static String[] MANAGED_OBJECT_GROUP_PROPERTIES;
    private static String[] TASK_PROPERTIES;
    private static String[] TASK_GROUP_PROPERTIES;
    private static final String TRACE_MASKT = "HUIOBJWT";
    private static final String TRACE_MASKF = "HUIOBJWF";
    private static final String TRACE_MASKD = "HUIOBJWD";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObject;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Task;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$Group;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$ManagedObjectGroup;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$HMC;

    private UIObjectsWriter() {
    }

    public static UIObjectsWriter getUIObjectsWriter() {
        if (instance == null) {
            throw new IllegalStateException("Error, the UIObjectsWriter singleton is null.");
        }
        return instance;
    }

    private void init() {
        Trace.trace(TRACE_MASKF, "-> UIObjectsWriter.init()");
        try {
            this.allSupportedStatus = new HashSet();
            this.statusShortIds = new HashMap();
            this.attentionTaskShortIds = new HashMap();
            this.uiActions = new HashMap();
            this.mom = ManagedObjectManager.getManagedObjectManager();
            this.shortIdManager = new ShortObjectIdManager();
            String pathName = BaseFileControl.getFilePath("uitmp");
            File path = new File(pathName);
            if (!path.exists()) {
                path.mkdir();
            } else {
                File[] tempFiles = path.listFiles();
                int i = 0;
                while (i < tempFiles.length) {
                    tempFiles[i].delete();
                    ++i;
                }
            }
            this.groupFilePrefix = pathName + "group.";
            this.taskGroupFilePrefix = this.groupFilePrefix + "task.";
            this.moGroupFilePrefix = this.groupFilePrefix + "mo.";
            this.objectsFile = new File(pathName + "objects");
            this.objectsWriter = new RandomAccessFile(this.objectsFile, "rws");
            this.recordOffsets = new UIObjectsOffsets(this.objectsWriter);
            this.unacceptableFile = new File(pathName + "unacceptablemanagedobjects");
            this.rootFile = new File(pathName + "rootmanagedobjects");
            this.worker = new Worker(this);
            ClassId[] types = new ClassId[]{new ClassId(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject), new ClassId(class$com$ibm$hwmca$fw$managed$Task == null ? (class$com$ibm$hwmca$fw$managed$Task = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Task")) : class$com$ibm$hwmca$fw$managed$Task), new ClassId(class$com$ibm$hwmca$fw$managed$Group == null ? (class$com$ibm$hwmca$fw$managed$Group = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Group")) : class$com$ibm$hwmca$fw$managed$Group)};
            instance = this;
            this.mom.addPropertyChangeListener((PropertyChangeListener)this, true, types);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            HException hexc = null;
            hexc = exc instanceof HException ? (HException)exc : new HException(exc);
            new FrameworkLog(UILog.logInfo, 1804, hexc).log();
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsWriter.init()");
    }

    public Set getAllowedShortIds() {
        return UIObjectsFilter.getAllowedShortIds(this.shortIdManager);
    }

    public Map getStatusShortIds() {
        return this.statusShortIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUIActions() {
        Object object = this.actionsLock;
        synchronized (object) {
            return (Map)this.uiActions.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUIActions(String[] shortIds) {
        HashMap<String, Collection> result = new HashMap<String, Collection>();
        Object object = this.actionsLock;
        synchronized (object) {
            int i = 0;
            while (i < shortIds.length) {
                Collection actions = (Collection)this.uiActions.get(shortIds[i]);
                if (actions != null && actions.size() > 0) {
                    result.put(shortIds[i], actions);
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttentionTaskShortId(ObjectId taskObjectId) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsWriter.addAttentionTaskShortId(), taskObjectId is " + taskObjectId);
        Object object = this.attnLock;
        synchronized (object) {
            if (!this.attentionTaskShortIds.containsKey(taskObjectId)) {
                String shortId = this.shortIdManager.add(taskObjectId);
                Trace.trace(TRACE_MASKF, "   adding shortId is " + shortId);
                this.attentionTaskShortIds.put(taskObjectId, shortId);
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsWriter.addAttentionTaskShortId()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAttentionTaskShortIds() {
        Object object = this.attnLock;
        synchronized (object) {
            return (Map)this.attentionTaskShortIds.clone();
        }
    }

    public ShortObjectIdManager getShortObjectIdManager() {
        return this.shortIdManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Trace.trace(TRACE_MASKF, "-> UIObjectsWriter.addPropertyChangeListener()");
        UserContext userContext = UserContext.getCurrentUserContext();
        ListenerData listenerData = null;
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new HashMap();
            }
            listenerData = new ListenerData(listener, userContext);
            this.listeners.put(listener, listenerData);
        }
        Trace.trace(TRACE_MASKF, "<- UIObjectsWriter.addPropertyChangeListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Object object = this.listenersLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> UIObjectsWriter.propertyChange()");
        this.worker.requestWork(evt);
        Trace.trace(TRACE_MASKT, "<- UIObjectsWriter.propertyChange()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MANAGED_OBJECT_PROPERTIES = new String[]{"AttentionTaskObjectId", "AttentionsExist", "Busy", "Locked", "ObjectId", "Root", "Status", "StatusAcceptable", "SupportedStatus", "UIInfo"};
        MANAGED_OBJECT_GROUP_PROPERTIES = new String[]{"Children", "Root", "StatusAcceptable", "UIInfo"};
        TASK_PROPERTIES = new String[]{"UIInfo", "MergedKey", "TargetRequired"};
        TASK_GROUP_PROPERTIES = new String[]{"Children", "Root", "UIInfo"};
    }

    public static final class Init
    implements Runnable {
        public void run() {
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "-> UIObjectsWriter#Init.run()");
            new UIObjectsWriter().init();
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "<- UIObjectsWriter#Init.run()");
        }
    }

    class ListenerData {
        UserContext userContext;
        PropertyChangeListener listener;

        ListenerData(PropertyChangeListener listener, UserContext userContext) {
            this.listener = listener;
            this.userContext = userContext;
        }
    }

    private class Worker
    implements WorkPerformer,
    WorkListener {
        private WorkThread workThread;
        private UIObjectsWriter instance;
        private static final int ADD = 1;
        private static final int REMOVE = 2;
        private static final int CHANGE = 3;

        public Worker(UIObjectsWriter instance) {
            this.instance = instance;
            this.workThread = new WorkThread("UIObjectsWriter.Worker");
            this.workThread.startWorker();
        }

        public void requestWork(PropertyChangeEvent evt) {
            this.workThread.requestWork(this, this, "ProperyChangeEvent", evt);
        }

        public Object performWork(Object data) {
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "-> UIObjectsWriter.Worker.performWork()");
            PropertyChangeEvent evt = (PropertyChangeEvent)data;
            ObjectId source = (ObjectId)evt.getSource();
            String propertyName = evt.getPropertyName();
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   source is " + source);
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   propertyName is " + propertyName);
            try {
                if (source.equals(UIObjectsWriter.this.mom.getObjectId())) {
                    boolean eventType = false;
                    List changes = null;
                    ObjectId[] ids = (ObjectId[])evt.getOldValue();
                    if (ids == null) {
                        ids = (ObjectId[])evt.getNewValue();
                        changes = this.objectsAdded(ids);
                    } else {
                        changes = this.objectsRemoved(ids);
                    }
                } else {
                    String shortId = UIObjectsWriter.this.shortIdManager.getShortId(source);
                    if (shortId == null) {
                        String s = "Got a property change event from an unknown source.\n  source is " + source;
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, s);
                        HException hexc = new HException(s);
                        FrameworkLog log = new FrameworkLog(UILog.logInfo, 1805, hexc);
                        log.add(s);
                        log.add(evt);
                        log.log(FrameworkLogAttributes.INFO_LOG);
                    } else if (UIObjectsWriter.this.recordOffsets.isOffsetKnown(shortId)) {
                        this.objectChanged(shortId, evt);
                    } else {
                        String s = "The shortId is not in the objects file.\n  shortId is [" + shortId + "]\n  source is [" + source + "]";
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, s);
                        HException hexc = new HException(s);
                        FrameworkLog log = new FrameworkLog(UILog.logInfo, 1815, hexc);
                        log.add(s);
                        log.add(evt);
                        log.log(FrameworkLogAttributes.INFO_LOG);
                    }
                }
            }
            catch (IOException ioexc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKT, ioexc);
                new FrameworkLog(UILog.logInfo, 1806, ioexc).log();
                HException hexc = new HException(ioexc);
                FrameworkLog log = new FrameworkLog(UILog.logInfo, 1806, hexc);
                log.add(evt);
                log.log();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKT, "<- UIObjectsWriter.Worker.performWork()");
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UIPropertyChangeEvent objectChanged(String shortId, PropertyChangeEvent evt) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.objectChanged()");
            int offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            String propertyName = evt.getPropertyName();
            UIPropertyChangeEvent newEvent = null;
            UIPropertyChangeEvent attnTaskEvent = null;
            if (propertyName.equals("Status")) {
                Status status = (Status)newValue;
                this.localizableTextChanged(status.getUIInfo().getUnlocalizedName(), offset, 272, 80, 352, 80);
                String statusShortId = (String)UIObjectsWriter.this.statusShortIds.get(status);
                byte[] buffer = new byte[8];
                this.copyString(buffer, statusShortId, 0, 8);
                UIObjectsWriter.this.objectsWriter.seek(offset + 16);
                UIObjectsWriter.this.objectsWriter.write(buffer);
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
            } else if (propertyName.equals("Locked")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 13);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
            } else if (propertyName.equals("Busy")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 10);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
            } else if (propertyName.equals("StatusAcceptable")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 12);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                Object[] ids = new String[]{shortId};
                if (((Boolean)newValue).booleanValue()) {
                    this.removeFromFile(ids, UIObjectsWriter.this.unacceptableFile);
                } else {
                    this.addToFile((String[])ids, UIObjectsWriter.this.unacceptableFile);
                }
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
            } else if (propertyName.equals("AttentionsExist")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 14);
                Boolean b = (Boolean)newValue;
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean(b, (byte)70));
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                attnTaskEvent = this.updateAttentionTask(shortId, b);
            } else if (propertyName.equals("AttentionTaskObjectId")) {
                ObjectId attnTaskObjectId = (ObjectId)newValue;
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "   new ATTENTION_TASK_OBJECTID_PROPERTY is " + attnTaskObjectId);
                UIObjectsWriter.this.addAttentionTaskShortId(attnTaskObjectId);
                String attnTaskShortId = UIObjectsWriter.this.shortIdManager.getShortId(attnTaskObjectId);
                byte[] buffer = new byte[8];
                this.copyString(buffer, attnTaskShortId, 0, 8);
                UIObjectsWriter.this.objectsWriter.seek(offset + 24);
                UIObjectsWriter.this.objectsWriter.write(buffer);
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)evt.getOldValue()), UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)evt.getNewValue()));
            } else if (propertyName.equals("Locked")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 13);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
            } else if (propertyName.equals("Children")) {
                ObjectId source = (ObjectId)evt.getSource();
                String parentShortId = UIObjectsWriter.this.shortIdManager.getShortId(source);
                if (parentShortId != null) {
                    byte type = 52;
                    if (source.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? (class$com$ibm$hwmca$fw$managed$ManagedObjectGroup = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup")) : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                        type = 50;
                    }
                    if (newValue == null) {
                        this.removeFromGroupFile(parentShortId, type, (ObjectId[])evt.getOldValue());
                    } else {
                        this.addToGroupFile(parentShortId, type, (ObjectId[])newValue);
                    }
                }
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, this.getShortIds((ObjectId[])evt.getOldValue()), this.getShortIds((ObjectId[])evt.getNewValue()));
            } else if (propertyName.equals("UIInfo")) {
                UIInfo newUIInfo = (UIInfo)newValue;
                this.localizableTextChanged(newUIInfo.getUnlocalizedName(), offset, 112, 80, 192, 80);
                this.localizableTextChanged(newUIInfo.getUnlocalizedCaption(), offset, 592, 80, 672, 80);
                this.imageNameChanged(newUIInfo.getImageName(), offset, 32, 80);
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
                Collection actions = newUIInfo.getUIActions();
                if (actions != null && actions.size() > 0) {
                    Iterator iterator = actions.iterator();
                    while (iterator.hasNext()) {
                        AbstractUIAction next = (AbstractUIAction)iterator.next();
                        if (!(next instanceof DisplayChildrenUIAction)) continue;
                        DisplayChildrenUIAction action = (DisplayChildrenUIAction)next;
                        String groupShortId = UIObjectsWriter.this.shortIdManager.add(action.getGroupObjectId());
                        action.setGroupShortId(groupShortId);
                    }
                }
                Object object = UIObjectsWriter.this.actionsLock;
                synchronized (object) {
                    if (actions != null && actions.size() > 0) {
                        UIObjectsWriter.this.uiActions.put(shortId, actions);
                    } else {
                        UIObjectsWriter.this.uiActions.remove(shortId);
                    }
                }
            } else if (propertyName.equals("Root")) {
                UIObjectsWriter.this.objectsWriter.seek(offset + 11);
                UIObjectsWriter.this.objectsWriter.writeByte(this.getByteFromBoolean((Boolean)newValue, (byte)70));
                Object[] ids = new String[]{shortId};
                if (((Boolean)newValue).booleanValue()) {
                    this.addToFile((String[])ids, UIObjectsWriter.this.rootFile);
                } else {
                    this.removeFromFile(ids, UIObjectsWriter.this.rootFile);
                }
                newEvent = new UIPropertyChangeEvent(shortId, propertyName, oldValue, newValue);
            } else if (propertyName.equals("SupportedStatus")) {
                if (this.updateSupportedStatus((Status[])evt.getNewValue())) {
                    newEvent = new UIPropertyChangeEvent("UIObjectsWriter", propertyName, null, UIObjectsWriter.this.allSupportedStatus);
                }
            } else {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "Error in UIObjectsWriter.Worker.objectChanged(), unknown property received, property name is " + propertyName);
            }
            if (newEvent != null) {
                this.sendChangeEvent((ObjectId)evt.getSource(), newEvent, attnTaskEvent);
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.objectChanged()");
            return newEvent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List objectsAdded(ObjectId[] ids) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.objectsAdded()");
            Object newAttnTaskShortIds = null;
            ArrayList<String> addedShortIds = new ArrayList<String>();
            ArrayList<String> unacceptableShortIds = null;
            ArrayList<String> rootShortIds = null;
            String[] propertyNames = null;
            byte[] buffer = new byte[752];
            byte type = 48;
            int i = 0;
            while (i < ids.length) {
                block49: {
                    try {
                        List children;
                        UIInfo uiInfo;
                        Boolean b;
                        if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$HMC == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.HMC") : class$com$ibm$hwmca$fw$managed$HMC)) {
                            type = 53;
                            propertyNames = MANAGED_OBJECT_PROPERTIES;
                        } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject") : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                            type = 49;
                            propertyNames = MANAGED_OBJECT_PROPERTIES;
                        } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObjectGroup == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObjectGroup") : class$com$ibm$hwmca$fw$managed$ManagedObjectGroup)) {
                            type = 50;
                            propertyNames = MANAGED_OBJECT_GROUP_PROPERTIES;
                        } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$Group == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Group") : class$com$ibm$hwmca$fw$managed$Group)) {
                            type = 52;
                            propertyNames = TASK_GROUP_PROPERTIES;
                        } else if (ids[i].isInstanceOf(class$com$ibm$hwmca$fw$managed$Task == null ? UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.Task") : class$com$ibm$hwmca$fw$managed$Task)) {
                            type = 51;
                            propertyNames = TASK_PROPERTIES;
                        } else {
                            propertyNames = null;
                        }
                        if (propertyNames == null) {
                            String s = "MOM sent an invalid object type.\nObjectId is " + ids[i];
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, s);
                            FrameworkLog log = new FrameworkLog(UILog.logInfo, 1805);
                            log.add(s);
                            log.log(FrameworkLogAttributes.INFO_LOG);
                            break block49;
                        }
                        int j = 0;
                        while (j < propertyNames.length) {
                            UIObjectsWriter.this.mom.addPropertyChangeListener(ids[i], propertyNames[j], this.instance, false);
                            ++j;
                        }
                        Map properties = UIObjectsWriter.this.mom.getProperties(ids[i], propertyNames);
                        if (UIObjectProperties.isManagedObject(type)) {
                            Set supportedStatus = (Set)properties.get("SupportedStatus");
                            Iterator iterator = supportedStatus.iterator();
                            while (iterator.hasNext()) {
                                Status status = (Status)iterator.next();
                                if (UIObjectsWriter.this.allSupportedStatus.contains(status)) continue;
                                UIObjectsWriter.this.allSupportedStatus.add(status);
                                String s = Integer.toHexString(UIObjectsWriter.this.allSupportedStatus.size()).toUpperCase();
                                if (s.length() == 1) {
                                    UIObjectsWriter.this.statusShortIds.put(status, "STATUS0" + s);
                                    continue;
                                }
                                UIObjectsWriter.this.statusShortIds.put(status, "STATUS" + s);
                            }
                        }
                        String shortId = UIObjectsWriter.this.shortIdManager.add(ids[i]);
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   add shortId " + shortId + " for ObjectId " + ids[i]);
                        int offset = -1;
                        if (UIObjectsWriter.this.recordOffsets.isOffsetKnown(shortId)) {
                            offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
                        } else {
                            offset = (int)UIObjectsWriter.this.objectsWriter.length();
                            UIObjectsWriter.this.recordOffsets.add(shortId, offset);
                        }
                        this.initObjectsFileBuffer(shortId, ids[i], properties, type, buffer);
                        UIObjectsWriter.this.objectsWriter.seek(offset);
                        UIObjectsWriter.this.objectsWriter.write(buffer);
                        addedShortIds.add(shortId);
                        if (UIObjectProperties.isManagedObject(type) || UIObjectProperties.isGroup(type)) {
                            b = (Boolean)properties.get("Root");
                            if (b == null) {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   root property is null");
                            } else {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   root property is " + b);
                            }
                            if (b != null && b.booleanValue()) {
                                if (rootShortIds == null) {
                                    rootShortIds = new ArrayList<String>();
                                }
                                rootShortIds.add(shortId);
                            }
                        }
                        if ((UIObjectProperties.isManagedObject(type) || UIObjectProperties.isManagedObjectGroup(type)) && (uiInfo = (UIInfo)properties.get("UIInfo")) != null) {
                            Collection actions = uiInfo.getUIActions();
                            UIPropertyChangeEvent actionEvent = null;
                            if (actions != null && actions.size() > 0) {
                                Iterator iterator = actions.iterator();
                                while (iterator.hasNext()) {
                                    AbstractUIAction next = (AbstractUIAction)iterator.next();
                                    if (!(next instanceof DisplayChildrenUIAction)) continue;
                                    DisplayChildrenUIAction action = (DisplayChildrenUIAction)next;
                                    String groupShortId = UIObjectsWriter.this.shortIdManager.add(action.getGroupObjectId());
                                    action.setGroupShortId(groupShortId);
                                }
                                Object object = UIObjectsWriter.this.actionsLock;
                                synchronized (object) {
                                    int numUIActions = UIObjectsWriter.this.uiActions.size();
                                    UIObjectsWriter.this.uiActions.put(shortId, actions);
                                    if (numUIActions != UIObjectsWriter.this.uiActions.size()) {
                                        actionEvent = new UIPropertyChangeEvent("UIObjectsWriter", "UIActionsMap", null, UIObjectsWriter.this.uiActions.clone());
                                    }
                                }
                            }
                            if (actionEvent != null) {
                                this.sendChangeEvent(ids[i], actionEvent, null);
                            }
                        }
                        if (UIObjectProperties.isGroup(type) && (children = (List)properties.get("Children")) != null) {
                            this.addToGroupFile(shortId, type, children);
                        }
                        if (UIObjectProperties.isManagedObject(type)) {
                            b = (Boolean)properties.get("StatusAcceptable");
                            if (b == null) {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   status acceptable property is null");
                            } else {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   status acceptable property is " + b);
                            }
                            if (b != null && !b.booleanValue()) {
                                if (unacceptableShortIds == null) {
                                    unacceptableShortIds = new ArrayList<String>();
                                }
                                unacceptableShortIds.add(shortId);
                            }
                            if ((b = (Boolean)properties.get("AttentionsExist")) == null) {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   attentions exist property is null");
                            } else {
                                Trace.trace(UIObjectsWriter.TRACE_MASKD, "   attentions exist property is " + b);
                            }
                            if (b != null && b.booleanValue()) {
                                ObjectId id = (ObjectId)properties.get("AttentionTaskObjectId");
                                if (id == null) {
                                    Trace.trace(UIObjectsWriter.TRACE_MASKD, "   could not find attention task ObjectId");
                                } else {
                                    UIPropertyChangeEvent attnEvent = this.updateAttentionTask(shortId, true);
                                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   attnEvent is " + attnEvent);
                                    if (attnEvent != null) {
                                        this.sendChangeEvent(ids[i], null, attnEvent);
                                    }
                                }
                            }
                        }
                    }
                    catch (NoSuchObjectIdException exc) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   objectId no longer exists in MOM, is is " + ids[i]);
                    }
                    catch (Exception exc) {
                        FrameworkLog log = new FrameworkLog(UILog.logInfo, 1813, exc);
                        log.add("Caught exception adding ObjectId " + ids[i]);
                        log.log();
                    }
                }
                ++i;
            }
            if (unacceptableShortIds != null) {
                this.addToFile(unacceptableShortIds, UIObjectsWriter.this.unacceptableFile);
            }
            if (rootShortIds != null) {
                this.addToFile(rootShortIds, UIObjectsWriter.this.rootFile);
            }
            if (addedShortIds.size() > 0) {
                this.sendInventoryEvent(1, addedShortIds);
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.objectsAdded()");
            return addedShortIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List objectsRemoved(ObjectId[] ids) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.objectsRemoved()");
            Object[] shortIdArray = new String[1];
            ArrayList<String> removedShortIds = new ArrayList<String>();
            int i = 0;
            while (i < ids.length) {
                block12: {
                    String shortId = UIObjectsWriter.this.shortIdManager.getShortId(ids[i]);
                    if (shortId == null) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   could not find the shortId for ObjectId " + ids[i]);
                    } else {
                        try {
                            UIPropertyChangeEvent attnEvent;
                            byte[] buffer = this.getBuffer(shortId);
                            byte type = UIObjectProperties.getType(buffer);
                            boolean root = UIObjectProperties.isRoot(buffer);
                            int offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
                            UIObjectsWriter.this.objectsWriter.seek(offset + 8);
                            UIObjectsWriter.this.objectsWriter.writeByte(84);
                            removedShortIds.add(shortId);
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "   shortId " + shortId + " marked as deleted");
                            if (UIObjectProperties.isGroup(type)) {
                                String fileName = UIObjectProperties.isTaskGroup(type) ? UIObjectsWriter.this.taskGroupFilePrefix + shortId : UIObjectsWriter.this.moGroupFilePrefix + shortId;
                                File file = new File(fileName);
                                Trace.trace(UIObjectsWriter.TRACE_MASKF, "   deleting file " + fileName);
                                file.delete();
                            }
                            if (root) {
                                shortIdArray[0] = shortId;
                                this.removeFromFile(shortIdArray, UIObjectsWriter.this.rootFile);
                            }
                            if (UIObjectProperties.isManagedObject(type) && UIObjectProperties.attentionsExist(buffer) && (attnEvent = this.updateAttentionTask(shortId, false)) != null) {
                                this.sendChangeEvent(ids[i], null, attnEvent);
                            }
                            if (!UIObjectProperties.isManagedObject(type) && !UIObjectProperties.isManagedObjectGroup(type)) break block12;
                            Object object = UIObjectsWriter.this.actionsLock;
                            synchronized (object) {
                                UIObjectsWriter.this.uiActions.remove(shortId);
                            }
                        }
                        catch (InvalidIdException exc) {
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, exc.toString());
                        }
                    }
                }
                ++i;
            }
            if (removedShortIds.size() > 0) {
                this.sendInventoryEvent(2, removedShortIds);
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.objectsRemoved()");
            return removedShortIds;
        }

        private void imageNameChanged(String imageName, int offset, int offsetImg, int lengthImg) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.imageNameChanged()");
            byte[] buffer = new byte[752];
            this.copyString(buffer, imageName, 0, lengthImg);
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   write [" + new String(buffer, 0, lengthImg) + "] at offset " + (offset + offsetImg));
            UIObjectsWriter.this.objectsWriter.seek(offset + offsetImg);
            UIObjectsWriter.this.objectsWriter.write(buffer, 0, lengthImg);
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.imageNameChanged()");
        }

        private void localizableTextChanged(LocalizableText text, int offset, int offsetRes, int lengthRes, int offsetKey, int lengthKey) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.localizableTextChanged()");
            byte[] buffer = new byte[752];
            this.copyString(buffer, text.getResourceBundleName(), 0, lengthRes);
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   write [" + new String(buffer, 0, lengthRes) + "] at offset " + (offset + offsetRes));
            UIObjectsWriter.this.objectsWriter.seek(offset + offsetRes);
            UIObjectsWriter.this.objectsWriter.write(buffer, 0, lengthRes);
            this.copyString(buffer, text.getKey(), 0, lengthKey);
            Trace.trace(UIObjectsWriter.TRACE_MASKD, "   write [" + new String(buffer, 0, lengthKey) + "] at offset " + (offset + offsetKey));
            UIObjectsWriter.this.objectsWriter.seek(offset + offsetKey);
            UIObjectsWriter.this.objectsWriter.write(buffer, 0, lengthKey);
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.localizableTextChanged()");
        }

        private void initObjectsFileBuffer(String shortId, ObjectId objectId, Map properties, byte type, byte[] buffer) {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.initObjectsFileBuffer()");
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = 32;
                ++i;
            }
            this.copyString(buffer, shortId, 0, 8);
            if (properties == null) {
                buffer[8] = 84;
            } else {
                buffer[9] = type;
                buffer[8] = 70;
                UIInfo uiInfo = (UIInfo)properties.get("UIInfo");
                if (uiInfo == null) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   UIInfo is null for objectId " + objectId);
                    this.copyString(buffer, "NO NAME", 192, 80);
                    this.copyString(buffer, "com/ibm/hwmca/fw/images/default.gif", 32, 80);
                } else {
                    LocalizableText text = uiInfo.getUnlocalizedName();
                    this.copyString(buffer, text.getResourceBundleName(), 112, 80);
                    this.copyString(buffer, text.getKey(), 192, 80);
                    LocalizableText caption = uiInfo.getUnlocalizedCaption();
                    this.copyString(buffer, caption.getResourceBundleName(), 592, 80);
                    this.copyString(buffer, caption.getKey(), 672, 80);
                    this.copyString(buffer, uiInfo.getImageName(), 32, 80);
                }
                Status status = null;
                String key = null;
                if (UIObjectProperties.isManagedObject(type)) {
                    ObjectId attnTaskObjectId;
                    status = (Status)properties.get("Status");
                    if (status != null) {
                        uiInfo = status.getUIInfo();
                        if (uiInfo != null) {
                            LocalizableText text = uiInfo.getUnlocalizedName();
                            this.copyString(buffer, text.getResourceBundleName(), 272, 80);
                            this.copyString(buffer, text.getKey(), 352, 80);
                        }
                        String statusShortId = (String)UIObjectsWriter.this.statusShortIds.get(status);
                        this.copyString(buffer, statusShortId, 16, 8);
                    }
                    buffer[12] = this.getByteFromBoolean((Boolean)properties.get("StatusAcceptable"), (byte)70);
                    buffer[10] = this.getByteFromBoolean((Boolean)properties.get("Busy"), (byte)70);
                    buffer[13] = this.getByteFromBoolean((Boolean)properties.get("Locked"), (byte)70);
                    buffer[11] = this.getByteFromBoolean((Boolean)properties.get("Root"), (byte)70);
                    buffer[14] = this.getByteFromBoolean((Boolean)properties.get("AttentionsExist"), (byte)70);
                    if (objectId.isInstanceOf(class$com$ibm$hwmca$fw$managed$ManagedObject == null ? (class$com$ibm$hwmca$fw$managed$ManagedObject = UIObjectsWriter.class$("com.ibm.hwmca.fw.managed.ManagedObject")) : class$com$ibm$hwmca$fw$managed$ManagedObject)) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   AttentionsExist property is " + properties.get("AttentionsExist"));
                    }
                    if ((attnTaskObjectId = (ObjectId)properties.get("AttentionTaskObjectId")) == null) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   ATTENTION_TASK_OBJECTID_PROPERTY is null");
                    } else {
                        UIObjectsWriter.this.addAttentionTaskShortId(attnTaskObjectId);
                        String attnTaskShortId = UIObjectsWriter.this.shortIdManager.getShortId(attnTaskObjectId);
                        if (attnTaskShortId == null) {
                            attnTaskShortId = UIObjectsWriter.this.shortIdManager.add(attnTaskObjectId);
                        }
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   attnTaskShortId is " + attnTaskShortId);
                        this.copyString(buffer, attnTaskShortId, 24, 8);
                    }
                } else if (UIObjectProperties.isManagedObjectGroup(type)) {
                    buffer[12] = this.getByteFromBoolean((Boolean)properties.get("StatusAcceptable"), (byte)70);
                    buffer[11] = this.getByteFromBoolean((Boolean)properties.get("Root"), (byte)70);
                } else if (UIObjectProperties.isTaskGroup(type)) {
                    buffer[11] = this.getByteFromBoolean((Boolean)properties.get("Root"), (byte)70);
                    key = (String)objectId.getKeyProperty("Name");
                    if (key != null) {
                        this.copyString(buffer, key, 432, 80);
                    }
                } else if (UIObjectProperties.isTask(type)) {
                    Set set;
                    buffer[15] = this.getByteFromBoolean((Boolean)properties.get("TargetRequired"), (byte)84);
                    key = (String)objectId.getKeyProperty("Name");
                    if (key != null) {
                        this.copyString(buffer, key, 432, 80);
                    }
                    if ((key = (String)properties.get("MergedKey")) != null) {
                        this.copyString(buffer, key, 512, 80);
                    }
                    if ((set = this.getTaskShortIdsWithAttentions()).contains(shortId)) {
                        buffer[14] = 84;
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "attention exist set to true");
                    }
                } else {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "   Error, type is unknown, type is " + type);
                }
            }
            buffer[buffer.length - 1] = 10;
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.initObjectsFileBuffer()");
        }

        private boolean updateSupportedStatus(Status[] supportedStatus) {
            boolean changed = false;
            if (supportedStatus != null) {
                int size = UIObjectsWriter.this.allSupportedStatus.size();
                int i = 0;
                while (i < supportedStatus.length) {
                    if (!UIObjectsWriter.this.allSupportedStatus.contains(supportedStatus[i])) {
                        UIObjectsWriter.this.allSupportedStatus.add(supportedStatus[i]);
                        String s = Integer.toHexString(UIObjectsWriter.this.allSupportedStatus.size()).toUpperCase();
                        if (s.length() == 1) {
                            UIObjectsWriter.this.statusShortIds.put(supportedStatus[i], "STATUS0" + s);
                        } else {
                            UIObjectsWriter.this.statusShortIds.put(supportedStatus[i], "STATUS" + s);
                        }
                        changed = true;
                    }
                    ++i;
                }
            }
            return changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getListeners() {
            ArrayList listenersClone = null;
            Object object = UIObjectsWriter.this.listenersLock;
            synchronized (object) {
                if (UIObjectsWriter.this.listeners != null && UIObjectsWriter.this.listeners.size() > 0) {
                    listenersClone = new ArrayList();
                    Iterator iterator = UIObjectsWriter.this.listeners.values().iterator();
                    while (iterator.hasNext()) {
                        listenersClone.add(iterator.next());
                    }
                }
            }
            return listenersClone;
        }

        private void sendChangeEvent(ObjectId objectId, UIPropertyChangeEvent event, UIPropertyChangeEvent attnTaskEvent) {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.sendChangeEvent()");
            List listeners = this.getListeners();
            if (listeners != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    ListenerData listenerData = (ListenerData)iterator.next();
                    if (!UIObjectsFilter.isObjectAllowed(objectId, listenerData.userContext)) continue;
                    if (attnTaskEvent != null) {
                        listenerData.listener.propertyChange(attnTaskEvent);
                    }
                    if (event == null) continue;
                    listenerData.listener.propertyChange(event);
                }
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.sendChangeEvent()");
        }

        private void sendInventoryEvent(int eventType, List changes) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.sendInventoryEvent()");
            List listeners = this.getListeners();
            if (listeners != null) {
                Iterator iterator = listeners.iterator();
                while (iterator.hasNext()) {
                    UIPropertyChangeEvent event;
                    ListenerData listenerData = (ListenerData)iterator.next();
                    Set allowedShortIds = UIObjectsFilter.getAllowedShortIds(changes, listenerData.userContext, UIObjectsWriter.this.shortIdManager);
                    if (allowedShortIds.size() <= 0) continue;
                    String[] shortIds = allowedShortIds.toArray(new String[allowedShortIds.size()]);
                    if (eventType == 1) {
                        event = new UIPropertyChangeEvent("UIObjectsWriter", "AllowedShortIds", null, shortIds);
                        listenerData.listener.propertyChange(event);
                        event = new UIPropertyChangeEvent("UIObjectsWriter", "InventoryProperty", null, shortIds);
                        listenerData.listener.propertyChange(event);
                        continue;
                    }
                    event = new UIPropertyChangeEvent("UIObjectsWriter", "InventoryProperty", shortIds, null);
                    listenerData.listener.propertyChange(event);
                }
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.sendInventoryEvent()");
        }

        private UIPropertyChangeEvent updateAttentionTask(String moShortId, boolean moAttnsExist) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.updateAttentionTask()");
            UIPropertyChangeEvent result = null;
            try {
                Set attnTaskShortIds = this.getTaskShortIdsWithAttentions();
                byte[] buffer = this.getBuffer(moShortId);
                String taskShortId = UIObjectProperties.getAttentionTaskShortId(buffer);
                if (taskShortId != null) {
                    buffer = this.getBuffer(taskShortId);
                    boolean taskAttnsExist = UIObjectProperties.attentionsExist(buffer);
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "task attn exist is " + taskAttnsExist + ", managed object attn exist is " + moAttnsExist);
                    if (taskAttnsExist && !moAttnsExist) {
                        if (!attnTaskShortIds.contains(taskShortId)) {
                            int taskOffset = UIObjectsWriter.this.recordOffsets.getOffset(taskShortId);
                            UIObjectsWriter.this.objectsWriter.seek(taskOffset + 14);
                            UIObjectsWriter.this.objectsWriter.writeByte(70);
                            result = new UIPropertyChangeEvent(taskShortId, "AttentionsExist", Boolean.TRUE, Boolean.FALSE);
                            Trace.trace(UIObjectsWriter.TRACE_MASKF, "attention exist set to false for task shortId " + taskShortId);
                        }
                    } else if (!taskAttnsExist && moAttnsExist) {
                        int taskOffset = UIObjectsWriter.this.recordOffsets.getOffset(taskShortId);
                        UIObjectsWriter.this.objectsWriter.seek(taskOffset + 14);
                        UIObjectsWriter.this.objectsWriter.writeByte(84);
                        result = new UIPropertyChangeEvent(taskShortId, "AttentionsExist", Boolean.FALSE, Boolean.TRUE);
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "attention exist set to true for task shortId " + taskShortId);
                    }
                }
            }
            catch (InvalidIdException exc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, exc.toString());
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.updateAttentionTask()");
            return result;
        }

        private Set getTaskShortIdsWithAttentions() {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.getTaskShortIdsWithAttentions()");
            HashSet<String> result = new HashSet<String>();
            try {
                int numRecords = (int)(UIObjectsWriter.this.objectsWriter.length() / 752L);
                byte[] buffer = new byte[752];
                int i = 0;
                while (i < numRecords) {
                    String taskShortId;
                    UIObjectsWriter.this.objectsWriter.seek(i * 752);
                    int numRead = UIObjectsWriter.this.objectsWriter.read(buffer, 0, 752);
                    if (numRead != 752) {
                        throw new InvalidIdException("Could not read at offset " + i * 752 + ", should have read " + 752 + " bytes but only " + numRead + " bytes read.");
                    }
                    if (!UIObjectProperties.isDeleted(buffer) && UIObjectProperties.isManagedObject(buffer) && UIObjectProperties.attentionsExist(buffer) && (taskShortId = UIObjectProperties.getAttentionTaskShortId(buffer)) != null && !result.contains(taskShortId)) {
                        Trace.trace(UIObjectsWriter.TRACE_MASKF, "   adding taskShortId " + taskShortId);
                        result.add(taskShortId);
                    }
                    ++i;
                }
            }
            catch (IOException ioexc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                new FrameworkLog(UILog.logInfo, 1803, ioexc).log();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.getTaskShortIdsWithAttentions(), number returned is " + result.size());
            return result;
        }

        private byte[] getBuffer(String shortId) throws IOException {
            byte[] buffer = new byte[752];
            int offset = UIObjectsWriter.this.recordOffsets.getOffset(shortId);
            UIObjectsWriter.this.objectsWriter.seek(offset + 0);
            int numRead = UIObjectsWriter.this.objectsWriter.read(buffer, 0, 752);
            if (numRead != 752) {
                throw new InvalidIdException("Could not read shortId " + shortId + ", should have read " + 752 + " bytes but only " + numRead + " bytes read.");
            }
            return buffer;
        }

        private byte getByteFromBoolean(Boolean b, byte defaultValue) {
            if (b == null) {
                return defaultValue;
            }
            if (b.booleanValue()) {
                return 84;
            }
            return 70;
        }

        private byte[] getByteArray(int length, byte initValue) {
            byte[] bytes = new byte[length];
            int i = 0;
            while (i < length) {
                bytes[i] = initValue;
                ++i;
            }
            return bytes;
        }

        private void copyString(byte[] buffer, String s, int offset, int maxLength) {
            int length = 0;
            byte[] source = null;
            if (s != null && s.length() > 0) {
                if (s.length() <= maxLength) {
                    length = s.length();
                } else {
                    length = maxLength;
                    String s2 = "Need to increase 'objects' record length.  Wrote the first " + maxLength + " bytes of String [" + s + "]";
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, s2);
                    FrameworkLog log = new FrameworkLog(UILog.logInfo, 1807);
                    log.add(s2);
                    log.log(FrameworkLogAttributes.INFO_LOG);
                }
                source = s.getBytes();
            }
            int i = 0;
            while (i < maxLength) {
                buffer[i + offset] = i < length ? source[i] : 32;
                ++i;
            }
        }

        private void addToGroupFile(String parentShortId, byte type, List children) throws IOException {
            this.addToGroupFile(parentShortId, type, children.toArray(new ObjectId[children.size()]));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addToGroupFile(String parentShortId, byte type, ObjectId[] children) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.addToGroupFile()");
            OutputStreamWriter writer = null;
            try {
                try {
                    StringBuffer childrenBuffer = new StringBuffer();
                    int i = 0;
                    while (true) {
                        block9: {
                            if (i < children.length) break block9;
                        }
                        childrenBuffer.append(UIObjectsWriter.this.shortIdManager.add(children[i]) + ",");
                        ++i;
                    }
                    String fileName = UIObjectProperties.isTaskGroup(type) ? UIObjectsWriter.this.taskGroupFilePrefix + parentShortId : UIObjectsWriter.this.moGroupFilePrefix + parentShortId;
                    writer = new FileWriter(new File(fileName), true);
                    writer.write(childrenBuffer.toString());
                }
                catch (IOException ioexc) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                    throw ioexc;
                }
                Object var9_9 = null;
                {
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                catch (IOException ioexc) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ioexc) {}
            if (writer != null) {
                writer.close();
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.addToGroupFile()");
        }

        private void removeFromGroupFiles(String parentShortId, byte type, List children) throws IOException {
            this.removeFromGroupFile(parentShortId, type, children.toArray(new ObjectId[children.size()]));
        }

        private void removeFromGroupFile(String parentShortId, byte type, ObjectId[] children) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.removeFromGroupFile()");
            String fileName = UIObjectProperties.isTaskGroup(type) ? UIObjectsWriter.this.taskGroupFilePrefix + parentShortId : UIObjectsWriter.this.moGroupFilePrefix + parentShortId;
            this.removeFromFile(children, new File(fileName));
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.removeFromGroupFile()");
        }

        private void removeFromFile(Object[] ids, File file) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.removeFromFile()");
            InputStreamReader reader = null;
            OutputStreamWriter writer = null;
            try {
                if (file.exists() && file.length() > 0L) {
                    reader = new FileReader(file);
                    char[] buffer = new char[(int)file.length()];
                    int numRead = reader.read(buffer);
                    reader.close();
                    reader = null;
                    if ((long)numRead == file.length()) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(buffer);
                        int i = 0;
                        while (i < ids.length) {
                            int index;
                            String next = null;
                            next = ids[i] instanceof ObjectId ? UIObjectsWriter.this.shortIdManager.getShortId((ObjectId)ids[i]) : (String)ids[i];
                            if (next != null && (index = sb.indexOf(next = next + ",")) != -1) {
                                sb.delete(index, index + next.length());
                            }
                            ++i;
                        }
                        if (sb.length() == 0) {
                            file.delete();
                        } else {
                            writer = new FileWriter(file);
                            writer.write(sb.toString());
                        }
                    }
                }
            }
            catch (IOException ioexc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                throw ioexc;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ioexc) {}
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.removeFromGroupFile()");
        }

        private void addToFile(List shortIds, File file) throws IOException {
            this.addToFile(shortIds.toArray(new String[shortIds.size()]), file);
        }

        private void addToFile(String[] shortIds, File file) throws IOException {
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "-> UIObjectsWriter.Worker.addToFile()");
            char[] buffer = null;
            StringBuffer newBuffer = new StringBuffer();
            InputStreamReader reader = null;
            OutputStreamWriter writer = null;
            try {
                if (file.length() > 0L) {
                    buffer = new char[(int)file.length()];
                    reader = new FileReader(file);
                    reader.read(buffer);
                    reader.close();
                    reader = null;
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "    buffer.length is " + buffer.length);
                }
                if (buffer != null) {
                    newBuffer.append(buffer);
                }
                int i = 0;
                while (i < shortIds.length) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "    next is [" + shortIds[i] + "] newBuffer is [" + newBuffer + "]");
                    if (newBuffer.indexOf(shortIds[i]) == -1) {
                        newBuffer.append(shortIds[i]);
                        newBuffer.append(",");
                    }
                    ++i;
                }
                Trace.trace(UIObjectsWriter.TRACE_MASKF, "    newBuffer.length() is " + newBuffer.length());
                if (newBuffer.length() > 0 && (buffer == null || buffer.length != newBuffer.length())) {
                    Trace.trace(UIObjectsWriter.TRACE_MASKF, "    write file " + file.getName());
                    writer = new FileWriter(file);
                    writer.write(newBuffer.toString());
                }
            }
            catch (IOException ioexc) {
                Trace.trace(UIObjectsWriter.TRACE_MASKF, ioexc);
                throw ioexc;
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException ioexc) {}
            }
            Trace.trace(UIObjectsWriter.TRACE_MASKF, "<- UIObjectsWriter.Worker.addToFile()");
        }

        String[] getShortIds(ObjectId[] objectIds) {
            String[] result = null;
            if (objectIds != null) {
                result = new String[objectIds.length];
                int i = 0;
                while (i < objectIds.length) {
                    result[i] = UIObjectsWriter.this.shortIdManager.add(objectIds[i]);
                    ++i;
                }
            }
            return result;
        }

        public void workCompleted(WorkEvent event) {
            Trace.trace(UIObjectsWriter.TRACE_MASKT, " <> UIObjectsWriter.Worker.workCompleted()");
            if (event.hasException()) {
                new FrameworkLog(UILog.logInfo, 1814, event.getException()).log();
            }
        }
    }
}

